<?php
// public/view_offline.php
require __DIR__ . '/../src/auth.php';
require_login();
require __DIR__ . '/../src/db.php';

// Fetch All Offline RTs joined with Report details
$stmt = $pdo->query("
    SELECT t.*, r.service_provider, r.uploaded_at, r.filename 
    FROM offline_rt1000 t
    JOIN raw_reports r ON t.report_id = r.id
    ORDER BY r.uploaded_at DESC, r.service_provider ASC
");
$rows = $stmt->fetchAll();
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>All Offline RT1000</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-light bg-white border-bottom">
  <div class="container">
    <a class="navbar-brand" href="dashboard.php">Report System</a>
    <div>
        <a href="dashboard.php" class="btn btn-sm btn-outline-secondary">Back to Dashboard</a>
    </div>
  </div>
</nav>


<div class="container py-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3>All Offline RT1000 Properties <span class="badge bg-secondary"><?= count($rows) ?></span></h3>
        <a href="export_offline_txt.php" class="btn btn-dark">
            <i class="bi bi-file-text"></i> Export List to Text
        </a>
        
    </div>

    <div class="card shadow-sm">
        <div class="card-body p-0">
            <table class="table table-striped table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Provider</th>
                        <th>Uploaded</th>
                        <th>Prop ID</th>
                        <th>Property Name</th>
                        <th>RT Name</th>
                        <th class="text-end">Report</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach($rows as $r): ?>
                    <tr>
                        <td><span class="badge bg-info text-dark"><?= htmlspecialchars($r['service_provider']) ?></span></td>
                        <td><small><?= htmlspecialchars($r['uploaded_at']) ?></small></td>
                        <td><?= htmlspecialchars($r['property_id']) ?></td>
                        <td><?= htmlspecialchars($r['prop_name']) ?></td>
                        <td class="font-monospace text-danger"><?= htmlspecialchars($r['rt_name']) ?></td>
                        <td class="text-end">
                            <a href="view_report.php?id=<?= $r['report_id'] ?>#offline" class="btn btn-sm btn-outline-primary py-0">View</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
</body>
</html>